package gov.va.med.mhv.health.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="IMMUNIZATIONS")
public class Immunization implements Serializable{

	private static final long serialVersionUID = -1212494645009875097L;
	
    @Id
	@Column(name="IMMUNIZATION_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO) 
	private Long id;
    
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="DATE_RECEIVED")
	@Temporal(TemporalType.DATE)
	private Date dateReceived;
	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="VACCINATION_METHOD")
	private String vaccinationMethod;
	
	@Column(name="VACCINE_TYPE_CODE")
	private String vaccinationTypeCode;
	
	@Column(name="OTHER_VACCINE")
	private String otherVaccine;
	
	@Column(name="REACTION_TYPE_CODE")
	private String reactionTypeCode;
	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;
	
	
	@OneToMany(mappedBy="immunization",cascade=CascadeType.ALL,fetch=FetchType.EAGER)
	private List<ImmunizationReaction> reactions;


	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public Integer getOplock() {
		return oplock;
	}


	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}


	public Date getDateReceived() {
		return dateReceived;
	}


	public void setDateReceived(Date dateReceived) {
		this.dateReceived = dateReceived;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getVaccinationMethod() {
		return vaccinationMethod;
	}


	public void setVaccinationMethod(String vaccinationMethod) {
		this.vaccinationMethod = vaccinationMethod;
	}


	public String getVaccinationTypeCode() {
		return vaccinationTypeCode;
	}


	public void setVaccinationTypeCode(String vaccinationTypeCode) {
		this.vaccinationTypeCode = vaccinationTypeCode;
	}


	public String getOtherVaccine() {
		return otherVaccine;
	}


	public void setOtherVaccine(String otherVaccine) {
		this.otherVaccine = otherVaccine;
	}


	public String getReactionTypeCode() {
		return reactionTypeCode;
	}


	public void setReactionTypeCode(String reactionTypeCode) {
		this.reactionTypeCode = reactionTypeCode;
	}


	public Long getUserprofileId() {
		return userprofileId;
	}


	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}


	public List<ImmunizationReaction> getReactions() {
		return reactions;
	}


	public void setReactions(List<ImmunizationReaction> reactions) {
		this.reactions = reactions;
	}

}
